<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('skill_name', 'skill_slug', 'skill_type_id', 'capacity');
    protected $visible = array('skill_name', 'skill_type_id', 'capacity');

    public function skillType()
    {
        return $this->belongsTo('App\Models\LuSkillType', 'skill_type_id', 'skill_type_id');
    }

}